/**
* \file: UspiInputSource.h
*
* \version: 2.0
*
* \release: $Name:$
*
* Input source endpoint implementation using USPI touch
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/ESM / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef BDCL_USPIINPUTSOURCE_H
#define BDCL_USPIINPUTSOURCE_H

#include <string>
#include <memory>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditInputSource.h>

namespace adit { namespace bdcl {

class UspiInputSourceImpl;

/** @class  UspiInputSource
 *  @brief  USPI touch specific input source implementation.
 */
class UspiInputSource : public AditInputSource
{
public:
    /** @brief  constructor
     *  @param  inCallbacks: callbacks used to notify MC
     *  @param  inCallbackDealer: callback dealer dispatching the callbacks from the Baidu core. For USPI touch context,
     *          it is also used as session identifier.
     */
    UspiInputSource(IAditInputSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);

    virtual ~UspiInputSource();

    /** @brief Configuration interface for each parameter. For current BDCL USPI touch implementation, there is no
     *         configuration needed.
     *  @param inKey: name of the configuration parameter
     *  @param inValue: the actual value for configuration
     */
    void setConfigItem(std::string inKey, std::string inValue);

    /** @brief  initialize and set configured parameters to USPI interface
     *  @return true on success, false on failure
     **/
    bool initialize();
    /** @brief  shutdown the endpoint and deinitialize the underlying USPI touch implementation
    */
    void teardown();

private:
    std::unique_ptr<UspiInputSourceImpl> impl;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_USPIINPUTSOURCE_H */
